<?php
set_time_limit(300);
ini_set('display_errors', 1);
error_reporting(E_ALL);

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'PHPMailer/src/Exception.php';
require 'PHPMailer/src/PHPMailer.php';
require 'PHPMailer/src/SMTP.php';

$mainEmail = trim($_POST['main_email']);
$bccEmails = $_POST['bcc_emails'];
$replyto   = trim($_POST['replyto']);
$subject   = $_POST['subject'];
$message   = $_POST['message'];

if (!filter_var($mainEmail, FILTER_VALIDATE_EMAIL)) {
    die("<div class='error'>Invalid Main Receiver Email</div>");
}

$emailList = preg_split('/[\s,]+/', $bccEmails);
$emailList = array_unique(array_filter($emailList));

$validEmails = [];
$invalidEmails = [];

/* ===============================
   BOUNCE PROTECTION LIST
   =============================== */
$suppressionFile = "suppression.txt";
$suppressed = file_exists($suppressionFile) ? file($suppressionFile, FILE_IGNORE_NEW_LINES) : [];

foreach($emailList as $email){

    $email = trim($email);

    if(!filter_var($email, FILTER_VALIDATE_EMAIL)){
        $invalidEmails[] = $email;
        continue;
    }

    $domain = substr(strrchr($email, "@"), 1);

    if(!checkdnsrr($domain, "MX")){
        $invalidEmails[] = $email;
        continue;
    }

    if(in_array($email, $suppressed)){
        continue; // skip suppressed emails
    }

    $validEmails[] = $email;
}

/* ===============================
   BATCHING 50 PER ROUND
   =============================== */

$batches = array_chunk($validEmails, 50);
$totalSent = 0;

foreach($batches as $batch){

    $mail = new PHPMailer(true);

    try {
         $mail->isSMTP();
    $mail->Host       = 'smtp.zeptomail.eu';
    $mail->SMTPAuth   = true;
    $mail->Username   = 'emailapikey';
    $mail->Password   = 'yA6KbHtdvQyklmoCEhVo1ZXY8o80r6xv3Cy24yHneZRxI9ni2qE70kBvINrpJjHdjILTsqtZb4xCIdrs7NBWL5BgMtBWf5TGTuv4P2uV48xh8ciEYNYkgZyvBbMTGqdOcBgmCioxTvElWA==';
    $mail->SMTPSecure = 'ssl';
    $mail->Port       = 465;


        $mail->setFrom('info@bloomshippingbv.online', 'Bloom Shipping');
        $mail->addAddress($mainEmail);

        if(!empty($replyto) && filter_var($replyto, FILTER_VALIDATE_EMAIL)){
            $mail->addReplyTo($replyto);
        }

        foreach($batch as $email){
            $mail->addBCC($email);
        }

        if(!empty($_FILES['attachments']['name'][0])){
            foreach($_FILES['attachments']['tmp_name'] as $key => $tmp_name){
                $mail->addAttachment($tmp_name, $_FILES['attachments']['name'][$key]);
            }
        }

        $mail->addEmbeddedImage('logo.png', 'companylogo');

        $mail->isHTML(true);
        $mail->Subject = $subject;
        $mail->Body    = $message;

        $mail->send();
        $totalSent += count($batch);

        $mail->smtpClose();

    } catch (Exception $e) {
        foreach($batch as $failedEmail){
            file_put_contents($suppressionFile, $failedEmail.PHP_EOL, FILE_APPEND);
        }
    }
}

/* ===============================
   FINAL OUTPUT
   =============================== */

echo "<div class='success'>Bulk Email Process Completed</div>";
echo "<div><strong>Total Valid Recipients:</strong> ".count($validEmails)."</div>";
echo "<div><strong>Total Sent:</strong> $totalSent</div>";

if(!empty($invalidEmails)){
    echo "<div class='error'><strong>Invalid Emails Removed:</strong><br>";
    echo implode("<br>", $invalidEmails);
    echo "</div>";
}

echo "<br><a href='index.php'>Go Back</a>";